<?php
if ($function_file_already_included) return;
$function_file_already_included = 1;

function get_icon_for_mime($mime, $file=NULL) {
	$mime_types=array(
		"application/msword"		=> "doc.gif",
		"application/pdf"		=> "pdf.gif",
		"application/rtf"		=> "doc.gif",
		"application/vnd.ms-excel"	=> "xls.gif",
		"application/x-bzip2"		=> "rar.gif",
		"application/x-excel"		=> "xls.gif",
		"application/x-gtar"		=> "rar.gif",
		"application/x-gzip"		=> "rar.gif",
		"application/x-shockwave-flash"	=> "swf.gif",
		"application/x-tar"		=> "rar.gif",
		"application/zip"		=> "rar.gif",
		"audio/3gpp"			=> "mpeg.gif",
		"audio/midi"			=> "mp3.gif",
		"audio/mpeg"			=> "mp3.gif",
		"audio/x-wav"			=> "mp3.gif",
		"image/bmp"			=> "jpeg.gif",
		"image/fif"			=> "jpeg.gif",
		"image/gif"			=> "jpeg.gif",
		"image/ief"			=> "jpeg.gif",
		"image/jpeg"			=> "jpeg.gif",
		"image/png"			=> "jpeg.gif",
		"image/tiff"			=> "jpeg.gif",
		"text/html"			=> "html.gif",
		"text/plain"			=> "txt.gif",
		"text/richtext"			=> "txt.gif",
		"text/xml"			=> "txt.gif",
		"text/xsl"			=> "txt.gif",
		"video/mpeg"			=> "mpeg.gif",
		"video/quicktime"		=> "mpeg.gif",
		"video/x-msvideo"		=> "mpeg.gif",
	);

	if ($mime=="application/octet-stream") {
		$ext=strtolower(preg_replace("/.*\.([^\.]*)$/", "\\1", $file));
		$types=array(
			"rar"	=> "rar.gif",
			"fla"	=> "fla.gif",
			"chm"	=> "chm.gif",
			"hlp"	=> "hlp.gif",
			"psd"	=> "psd.gif",
		);
		return (isset($types[$ext]) ? $types[$ext] : "none.gif");
	}
	return (isset($mime_types[$mime]) ? $mime_types[$mime] : "none.gif");
}

function get_file($fn) {
        if (!is_file($fn))
                return "File not found: $fn";
        $fl = fopen($fn, "r");
        $fs = fread($fl, filesize($fn));
        fclose($fl);
        return $fs;
}

function get_file_size($file) {
        if (!is_file($file)) return "";
        $a = filesize($file);
        if ($a>1024*1024*1024)
                return round($a/(1024*1024*1024),2)." {rs:GB}";
        else if ($a>1024*1024)
                return round($a/(1024*1024),2)." {rs:MB}";
        else if ($a>1024)
                return round($a/(1024))." {rs:KB}";
        else
                return $a." {rs:B}";
}

function _upload_file($str,$prefix="f",$anysize=1,$anytype=1) {
        global $config, $$str;

        $file = $$str;

        $tmp = $str."_type";
        global $$tmp;

        $file_type = $$tmp;
        
        $tmp = $str."_name";
        global $$tmp;

        $file_name = $$tmp;
        
        if ($file!="none" && $file!="") {
                list($file_type, $shit) = split("; ", $file_type);
                if (!in_array($file_type, $config["types"]["image"]) && $anytype==0) {
                        print "wrong type";
                        unlink($file);
                        $fname = "";
                } elseif (filesize($file)>$config["image"]["weight"] && $anysize==0) {
                        print "wrong size";
                        unlink($file);
                        $fname = "";
                } else {
                        list($w,$h,$s,$i) = getimagesize($file);
                        if (($w>$config["image"]["width"]||$h>$config["image"]["height"]) && $anysize=0) {
                                print "wrong dimensions";
                                unlink($file);
                                $fname = "";
                        } else {
                                $items = split("\.", $file_name);
                                $fname = $prefix.time().".".$items[sizeof($items)-1];
                                copy($file, $config["data-dir"]."/".$fname);
                                unlink($file);
                        }
                }
        } else {
                $fname = "";
        }
        return $fname;
}

function convert_file_name($filename="") {
        return str_replace(
                array(" ","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","", "'", ",", "\"", "-"),
                array("_","a","b","v","g","d","e","e","zh","z","i","j","k","l","m","n","o","p","r","s","t","u","f","h","ts","ch","sh","sch","e","yu","ya","","","y","i","yi","A","B","V","G","D","E","E","ZH","Z","I","J","K","L","M","N","O","P","R","S","T","U","F","H","TS","CH","SH","SCH","E","YU","YA","","","Y","I","YI", "", "", "", "_"),
                $filename
        );      
}

function get_new_docname($file) {
        if ($file) {
	        $filetype=explode(".", $file);
	        if (count($filetype)) return convert_file_name($filetype[0]."_".time().".".$filetype[count($filetype)-1]);
        }
        return "";
}

function upload($filename,$new_filename) {
	if (is_file($filename) and ($new_filename)) {
		copy($filename, $new_filename);
		return $new_filename;
	}
	return "";
}

function upload_image($src, $dest, $width=0, $height=0) {
        if (!is_file($src)) return;

	list($w, $h, $s, $t)=getimagesize($src);
	if ($width or $height) {
		$d=min(($width ? $width/$w : 1), ($height ? $height/$h : 1));
		if ($d>1) $d=1;
	} else $d=1;
	$width=intval($w*$d);
	$height=intval($h*$d);
        $i1 = imagecreatefromjpeg($src);

        if (function_exists("imagecreatetruecolor")) {
                $i2 = imagecreatetruecolor($width,$height);
                imagecopyresampled($i2, $i1, 0, 0, 0, 0, $width, $height, $w, $h);
        } else {
                $i2 = imagecreate($width,$height);
                imagecopyresized($i2, $i1, 0, 0, 0, 0, $width, $height, $w, $h);
        }
        imagejpeg($i2, $dest, 100);
}
?>