<?php
// TaskList v.1.0.1

class task {

	var $status;
	var $count;
	var $items=array();
	
	function task($status='', $count=0) {
		$this->status=$status;
		$this->count=$count;
	}

	function add($url, $description='', $count) {
		$this->items[]=array(
			'url'		=> $url,
			'description'	=> $description,
			'count'		=> $count,
		);
	}

	function getXML() {
		if (!class_exists('XMLCreator')) die("Class 'XMLCreator' not found");
		$xml=new XMLCreator(false);
		$xml->openTag('task');
		$xml->addTag('status', $this->status);
		$xml->addTag('count', $this->count);
		foreach ($this->items as $name => $value) $xml->addTag('item', $value);
		$xml->closeTag('task');
		return $xml->get();
	}
}

class taskList {

	var $list=Array();
	var $br="\n";

	function taskList() {
		$this->list=Array();
	}

	// for PHP4
	function add($task=NULL) {
		if (isset($task)) $this->list[]=$task;
	}

	// for PHP5
	/*
	function add($status='', $count=0) {
		return $this->list[]=new task($status, $count);
	}
	*/
	
	function reset() {
		$this->list=array();
	}

	function getXML() {
		if (!class_exists('XMLCreator')) die("Class 'XMLCreator' not found");
		$xml=new XMLCreator();
		$xml->openTag('taskList');
		foreach ($this->list as $key => $value) $xml->addXML($value->getXML());
		$xml->closeTag('taskList');
		return $xml->get();
	}

	function output() {
		$xml=$this->getXML();
		header('Content-type: text-xml');
		header('Content-Length: '.strlen($xml));
		print $xml;
	}
}

?>