<?php
class Photo {

	/**
	*  
	*
	* @var int
	*/
	var $error_code=0;

	/**
	*  
	*
	* @var array
	*/
	var $error_list=array(
		-1	=> "File not found",
		-2	=> "Wrong image format",
		-3	=> "Watermark not found",
		-4	=> "Wrong watermark-image format");

	/**
	*    
	*
	* @var string
	*/
	var $path="/files/";

	/**
	*  
	*
	* @var string
	*/
	var $mime_type;

	/**
	* -
	*
	* @var resource
	*/
	var $src;

	/**
	*  -
	*
	* @var int
	*/
	var $src_width=0;

	/**
	*  -
	*
	* @var int
	*/
	var $src_height=0;

	/**
	*    -
	*
	* @var string
	*/
	var $src_path="orig/";

	/**
	*  -
	*
	* @var int
	*/
	var $pr_width=100;

	/**
	*  -
	*
	* @var int
	*/
	var $pr_height=100;

	/**
	*    -
	*
	* @var string
	*/
	var $pr_path="pre/";

	/**
	*   
	*
	* @var int
	*/
	var $big_width=640;

	/**
	*   
	*
	* @var int
	*/
	var $big_height=480;

	/**
	*     
	*
	* @var string
	*/
	var $big_path="big/";

	/**
	*   (  )
	*
	* @var int
	*/
	var $watermark=0;

	/**
	*    
	*
	* @var string
	*/
	var $watermark_pr="/files/watermark/pr.png";

	/**
	*     
	*
	* @var string
	*/
	var $watermark_big="/files/watermark/big.png";

	/**
	*    
	*
	* @var string
	*/
	var $watermark_align="center";

	/**
	*    
	*
	* @var string
	*/
	var $watermark_valign="center";

	/**
	*  open()    
	*
	* @return resource
	*/
	function open($filename, $save_mime=false) {
		if (is_file($filename)) {
			$mime=getimagesize($filename); $mime=$mime["mime"];
			if ($save_mime) $this->mime_type=$mime;
			if ($mime=="image/gif" and function_exists("imagecreatefromgif")) $img=imagecreatefromgif($filename);
			elseif ($mime=="image/jpeg" and function_exists("imagecreatefromjpeg")) $img=imagecreatefromjpeg($filename);
			elseif ($mime=="image/png" and function_exists("imagecreatefrompng")) $img=imagecreatefrompng($filename);
			else {
				$this->error_code=-2;
				return 0;
			}
			return $img;
		} else {
			$this->error_code=-1;
			return 0;
		}
	}

	/**
	*  src_open()  -
	*
	*/
	function src_open($filename) {
		if ($this->src=$this->open($filename, true)) {
			$this->src_file=$filename;
			$this->src_width=imagesx($this->src);
			$this->src_height=imagesy($this->src);
		}
	}

	/**
	*  save()    
	*
	*/
	function save($img, $filename) {
		global $DOCUMENT_ROOT;
		if ($this->mime_type=="image/gif") imagegif($img, $DOCUMENT_ROOT.$filename);
		elseif ($this->mime_type=="image/jpeg") imagejpeg($img, $DOCUMENT_ROOT.$filename, 100);
		elseif ($this->mime_type=="image/png") imagepng($img, $DOCUMENT_ROOT.$filename);
	}

	/**
	*  resize()     
	*
	* @return resource
	*/

	function resize($img, $width=0, $height=0) {
		if (!$this->error_code) {
			$img_width=imagesx($img);
			$img_height=imagesy($img);
			$dw=($width ? $width/$img_width : 1);
			$dh=($height ? $height/$img_height : 1);
			$d=min($dw, $dh);
			$d=($d>1 ? 1 : $d);
			$width=$d*$img_width;
			$height=$d*$img_height;
			if (function_exists("imagecreatetruecolor")) {
				$res=imagecreatetruecolor($width, $height);
				imagecopyresampled($res, $img, 0, 0, 0, 0, $width, $height, $img_width, $img_height);
			} else {
				$res=imagecreate($width, $height);
				imagecopyresized($res, $img, 0, 0, 0, 0, $width, $height, $img_width, $img_height);
			}
			return $res;
		} else return 0;
	}

	/**
	*  put_watermark()     
	*
	* @return resource
	*/

	function put_watermark($img, $watermark, $percent=100) {
		global $DOCUMENT_ROOT;
		if (is_file($DOCUMENT_ROOT.$watermark)) {
			$img_w=$this->open($DOCUMENT_ROOT.$watermark);
			if (!$this->error_code) {
				$x=($this->watermark_align=="left" ? 0 : ($this->watermark_align=="right" ? imagesx($img)-imagesx($img_w) : (imagesx($img)-imagesx($img_w))/2));
				$y=($this->watermark_valign=="top" ? 0 : ($this->watermark_valign=="bottom" ? imagesy($img)-imagesy($img_w) : (imagesy($img)-imagesy($img_w))/2));




				imagecopymerge($img, $img_w, $x, $y, 0, 0, imagesx($img_w), imagesy($img_w), $percent);
				imagedestroy($img_w);
			} else $this->error_code=-4;
		} else $this->error_code=-3;
		return $img;
	}

	/**
	*  make_pic()     ,      
	*
	* @return boolean
	*/
	function make_pic($filename, $new_filename, $pr_width=0, $pr_height=0, $big_width=0, $big_height=0, $watermark=0) {
		$this->src_open($filename);
		if (!$this->error_code) {
			//  
			if (!$pr_width and !$pr_height) {
				$pr_width=$this->pr_width;
				$pr_height=$this->pr_height;
			}
			$pr=$this->resize($this->src, $pr_width, $pr_height);

			//  
			if (!$big_width and !$big_height) {
				$big_width=$this->big_width;
				$big_height=$this->big_height;
			}
			$big=$this->resize($this->src, $big_width, $big_height);
			if ($watermark) {
				//$pr=$this->put_watermark($pr, $this->watermark_pr, $watermark);
				$big=$this->put_watermark($big, $this->watermark_big, $watermark);
			}
		}

		if (!$this->error_code) {
			// 
			//$this->save($this->src, $this->path.$this->src_path.$new_filename);
			$this->save($pr, $this->path.$this->pr_path.$new_filename);
			$this->save($big, $this->path.$this->big_path.$new_filename);
			imagedestroy($pr);
			imagedestroy($big);
			return true;
		} else return false;
	}

	/**
	*  get_error()  
	*
	* @return string
	*/
	function get_error() {
		return ($this->error_code ? $this->error_list[$this->error_code] : "");
	}

	function close() {
		@imagedestroy($this->src);
	}
}
?>