<?php
class mime_mail {
	var $parts;
	var $to;
	var $from;
	var $header;
	var $subject;
	var $body;
	var $boundary;
	var $charset="Windows-1251";

	function mime_mail() {
		$this->parts=array();
		$this->to="";
		$this->from="";
		$this->subject="";
		$this->body="";
		$this->header="";
		$this->boundary="b".md5(uniqid(time()));
	}

	function add_attachment ($message, $name="", $ctype="application/octet-stream") {
		$this->parts[]="

--".$this->boundary."
Content-Type: $ctype; name=\"$name\"
Content-Disposition: attachment; filename=\"$name\"
Content-Transfer-Encoding: base64
Content-ID: <$name>

".chunk_split(base64_encode($message));
	}

	function get_mail($complete=true, $type="text/plain", $c_type="multipart/mixed") {
		$mime="";
		if (!empty($this->from)) $mime.="From: ".$this->from."\n";
		if (!empty($this->header)) $mime.=$this->header."\n";
		if ($complete) {
			if (!empty($this->to)) $mime.="To: ".$this->to."\n";
			if (!empty($this->subject)) $mime.="Subject: ".$this->subject."\n";
		}
		$mime.="MIME-Version: 1.0
Content-Type: $c_type; boundary=\"".$this->boundary."\"

--".$this->boundary."
Content-Type: $type; charset=".$this->charset."
Content-Transfer-Encoding: 8bit

".$this->body;
		for ($i=0; $i<count($this->parts); $i++) $mime.=$this->parts[$i];
		return $mime."
--".$this->boundary."--";
	}

	function send($type="text/plain", $c_type="multipart/mixed") {
		$mime=$this->get_mail(false, $type, $c_type);
//		if (!mail($this->to, $this->subject, "", $mime)) print "Error of SEND<br>";
		@mail($this->to, $this->subject, "", $mime);
	}

	function print_message($type="text/plain", $c_type="multipart/mixed") {
		$mime=$this->get_mail(true, $type, $c_type);
		print nl2br(stripslashes(htmlspecialchars($mime)));
	}
}
?>