<?php
class Bar {
        var $color;
        var $dark_color;
        var $border;
        var $vals;

        function Bar($color, $dark_color, $border) {
                $this->color=$color;
                $this->dark_color=$dark_color;
                $this->border=$border;
                $this->vals=array();
        }

        function add_val($val) {
                $this->vals[]=$val;
        }
}

class Graf {
        var $img;
        var $background_color;
        var $line;
        var $text;
        var $bar;
        var $count;
        var $max;
        var $title;
        var $t_max;

        function Graf($width, $height) {
                ($this->img = @imagecreate($width, $height)) or die("Cannot Initialize new GD image stream");
                $background_color=imagecolorallocate($this->img, 255, 255, 255);
                $this->line=imagecolorallocate($this->img, 221, 221, 221);
                $this->text=imagecolorallocate($this->img, 32, 32, 32);
                $this->bar=array();
                $this->count=0;
                $this->max=0;
                $this->title=array();
                $this->t_max=0;
        }

        function add_bar($name, $color, $dark_color, $border) {
                $color=imagecolorallocate($this->img,
                        hexdec(substr($color, 0, 2)),
                        hexdec(substr($color, 2, 2)),
                        hexdec(substr($color, 4, 2))
                );
                $dark_color=imagecolorallocate($this->img,
                        hexdec(substr($dark_color, 0, 2)),
                        hexdec(substr($dark_color, 2, 2)),
                        hexdec(substr($dark_color, 4, 2))
                );
                $border=imagecolorallocate($this->img,
                        hexdec(substr($border, 0, 2)),
                        hexdec(substr($border, 2, 2)),
                        hexdec(substr($border, 4, 2))
                );

                $this->bar[$name]=new Bar($color, $dark_color, $border);
        }

        function add_val_to_bar($name, $val, $title="") {
                $this->bar[$name]->add_val($val);
                $this->count=($this->count<count($this->bar[$name]->vals) ? count($this->bar[$name]->vals) : $this->count);
                $this->max=($this->max<$val ? $val : $this->max);
        }

        function add_title($title) {
                $this->title[]=$title;
                $this->t_max=max(strlen($title), $this->t_max);
        }

        function execute($dz=10) {

                function f($x) {
                        $y=pow(10, strlen($x)-1);
                        return ($x<10 ? 10 : floor($x/$y+1)*$y);
                }

                function f2($x) {
                        $y=pow(10, strlen($x)-1);
                        return ($x>5*$y ? 10*$y : ($x>$y ? 5*$y : $x));
                }

                $x0=(count($this->bar)+1)*$dz;
//              $x0=($x0>60 ? $x0 : 60);
                $this->max=($this->max ? f($this->max) : $this->max);
                $L=strlen(number_format($this->max, 0, '.', ' '))+3;
                $width=imagesx($this->img)-$x0-$L*5;
                $height=imagesy($this->img)-$x0-$this->t_max*5;
                $y0=$height;
                imageline($this->img, $x0, $y0, $x0, 0, $this->line);
                imageline($this->img, $x0, $y0, $x0+$width, $y0, $this->line);
                imageline($this->img, $x0, $y0, $x0-(count($this->bar)+1)*$dz, $y0+(count($this->bar)+1)*$dz, $this->line);
                if ($this->count) {
                        $dx=($width-15)/$this->count;
                        $dy=($height-15)/$this->max;
                        for ($i=0; $i<=10; $i++) {
                                $y=ceil($i*$this->max/10);
                                $st=number_format($y, 0, '.', ' ');
                                $y=$y*$dy;
                                imageline($this->img, $x0, $y0-$y, $x0+$width, $y0-$y, $this->line);
                                imageline($this->img, $x0, $y0-$y, $x0-(count($this->bar)+1)*$dz, $y0-$y+(count($this->bar)+1)*$dz, $this->line);
                                $l=strlen($st)+1;
                                imagestring($this->img, 1, $x0+$width+($L-$l)*5, $y0-$y-3,  $st, $this->text);
                        }
                        while ($key=key($this->bar)) {
                                for ($i=0; $i<count($this->bar[$key]->vals); $i++) {
                                        $array=array(
                                                $x0+($i*$dx)-$dz, floor($y0-($this->bar[$key]->vals[$i]*$dy)+$dz),
                                                $x0+($i*$dx), floor($y0-($this->bar[$key]->vals[$i]*$dy)),
                                                $x0+(($i+1)*$dx), floor($y0-($this->bar[$key]->vals[$i]*$dy)),
                                                $x0+(($i+1)*$dx), $y0,
                                                $x0+(($i+1)*$dx)-$dz, $y0+$dz,
                                                $x0+($i*$dx)-$dz, $y0+$dz,
                                        );
                                        imagefilledpolygon($this->img, $array, 6, $this->bar[$key]->color);
                                        $array=array(
                                                $x0+($i*$dx)-$dz, floor($y0-($this->bar[$key]->vals[$i]*$dy)+$dz),
                                                $x0+($i*$dx), floor($y0-($this->bar[$key]->vals[$i]*$dy)),
                                                $x0+(($i+1)*$dx), floor($y0-($this->bar[$key]->vals[$i]*$dy)),
                                                $x0+(($i+1)*$dx), $y0,
                                                $x0+(($i+1)*$dx)-$dz, $y0+$dz,
                                                $x0+(($i+1)*$dx)-$dz, floor($y0-($this->bar[$key]->vals[$i]*$dy)+$dz),
                                        );
                                        imagefilledpolygon($this->img, $array, 6, $this->bar[$key]->dark_color);
                                        imagepolygon($this->img, $array, 6, $this->bar[$key]->border);                          
                                        imageline($this->img, $x0+($i*$dx)-$dz, $y0+$dz, $x0+($i*$dx)-$dz, floor($y0-($this->bar[$key]->vals[$i]*$dy)+$dz), $this->bar[$key]->border);
                                        imageline($this->img, $x0+($i*$dx)-$dz, $y0+$dz, $x0+(($i+1)*$dx)-$dz, $y0+$dz, $this->bar[$key]->border);
                                        imageline($this->img, $x0+(($i+1)*$dx), floor($y0-($this->bar[$key]->vals[$i]*$dy)), $x0+(($i+1)*$dx)-$dz, floor($y0-($this->bar[$key]->vals[$i]*$dy))+$dz, $this->bar[$key]->border);

                                }
                                next($this->bar);
                                $x0-=$dz;
                                $y0+=$dz;
                        }
                        for ($i=0; $i<count($this->title); $i++) {
                                $l=strlen($this->title[$i])+1;
                                imagestringup($this->img, 1, $x0+(($i+0.5)*$dx)-3, $y0+$l*5,  $this->title[$i], $this->text);
                        }
                }
                header("Content-type: image/png");
                imagepng($this->img);
        }

        function close() {
                imagedestroy($this->img);
        }
}
?>