<?php
Class Files {
	var $path;
	var $src=array();
	var $dest="";
	var $error;
	var $error_list=array(
		-1	=> "{rs:ERROR_FILE_NOT_FOUND}",
		-2	=> "{rs:ERROR_CANT_UPLOAD_FILE}",
	);

	function Files($path="../files/") {
		$this->path=$path;
	}

	function upload_file($array, $name="") {
		$this->src=$this->get_file_info($array, $name);
		$this->dest=$this->new_name($this->src["name"]);
		return $this->upload($this->src["tmp"], $this->dest);
	}

	function get_file_info($array, $name="") {
		return array(
			"name"	=> $array["name"][$name],
			"tmp"	=> $array["tmp_name"][$name],
			"type"	=> $array["type"][$name],
			"size"	=> $array["size"][$name],
		);
	}

	function new_name($filename) {
		list($name, $ext)=explode(".", $filename);
		return ru_to_en($name."_".time().".".$ext);
	}

	function ru_to_en($filename="") {
	        return str_replace(
	                array(" ","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","_","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","_","", "'", ",", "\"", "-"),
	                array("_","a","b","v","g","d","e","e","zh","z","i","j","k","l","m","n","o","p","r","s","t","u","f","h","ts","ch","sh","sch","e","yu","ya","","","y","i","yi","A","B","V","G","D","E","E","ZH","Z","I","J","K","L","M","N","O","P","R","S","T","U","F","H","TS","CH","SH","SCH","E","YU","YA","","","Y","I","YI", "", "", "", "_"),
	                $filename
	        );      
	}

	function upload($src, $dest) {
		$this->error=0;
		if (is_file($src)) {
			if (!copy($src, $this->path.$dest)) $this->error=-2;
		} else $this->error=-1;
		return ($this->error<0 ? false : true);
	}

	function get_error() {
		return $this->error_list[$this->error];
	}
}
?>