<?php
// XML Creator v.1.1.0

class XMLCreator {
	var $br="\n";
	var $xml='';
	var $output=false;

	function XMLCreator($isHeader=true) {
		if ($isHeader) $this->xml='<?xml version="1.0" encoding="UTF-8"?>'.$this->br;
		if ($this->output) print $this->xml;
	}

	function openTag($name, $add=true, $fl=true) {
		$res="<{$name}>".($fl ? $this->br : '');
		if ($add) {
			if ($this->output) print $res;
			else $this->xml.=$res;
		}
		return $res;
	}
	
	function closeTag($name, $add=true) {
		$res="</{$name}>".$this->br;
		if ($add) {
			if ($this->output) print $res;
			else $this->xml.=$res;
		}
		return $res;
	}

	function addTag($name, $value, $add=true) {
		$res=$this->openTag($name, false, is_array($value));
		if (is_array($value)) {
			foreach ($value as $key => $val) {
				$res.=$this->addTag($key, $val, false);
			}
		} else $res.=$value;
		$res.=$this->closeTag($name, false);
		if ($add) {
			if ($this->output) print $res;
			else $this->xml.=$res;
		}
		return $res;
	}

	function addXML($xml) {
		if ($this->output) print $xml;
		else $this->xml.=$xml;
	}

	function get() {
		return $this->xml;
	}

	function length() {
		return strlen($this->xml);
	}

	function output() {
		header('Content-type: text-xml');
		header('Content-Length: '.$this->length());
		print $this->xml;
	}
}
?>