#!/usr/local/bin/php -c /home/kvadra/public_html/php.ini
<?php
include "inc.php";
if (!isset($config)) exit;
$PATH=$config["path"];
chdir($DOCUMENT_ROOT.$PATH);
include "tools/db.php";
include "tools/tools.php";
include "tools/template.php";
include "tools/class.link.php";
include "tools/class.message.php";
include "tools/function.sql.php";
include "tools/class.msg.php";
$db = new DB();
$table="autoresponder".$config["table_prefix"];
$table_s="subscribers".$config["table_prefix"];
$table_sg="subscribers_group".$config["table_prefix"];
$table_g="mailing_groups".$config["table_prefix"];
$table_n="newsletters".$config["table_prefix"];
$msg=new msg("msg_autoresponder".$config["table_prefix"]);
$log="";
function add_log($text, $is_date=true, $is_enter=true, $is_print=false) {
        $text=($is_date ? date("d.m.y [H:i:s]> ") : "").$text.($is_enter ? "\n" : "");
        if ($is_print) print nl2br($text);
        return $text;
}

function get_subscribers($data) {
        global $db, $log, $msg, $table_s, $table_sg, $table_g;
        $log.=add_log("Find subsribers for task #".$data["id"].": ", true, false);
        $sql="select s.id from
                $table_s s,
                $table_sg sg,
                $table_g g
        where
                s.status='".$data["recipients"]."' and
                s.id=sg.subscribers_id and
                sg.group_id=g.id and
                g.enabled=1 and
                g.id in (".$data["groups"].")
        group by s.id";
        $sth=$db->execute($sql);
        $count=mysql_num_rows($sth);
        $log.=add_log($count." records find", false, true);
        while ($row=$db->get_row($sth)) {
                $msg->add(array(
                        "subscriber_id" => $row["id"],
                        "task_id"       => $data["id"],
                ));
                $log.=add_log("Created autoresponder #".$data["id"]." for subscriber #".$row["id"]);
        }
}

function check_task($sql) {
        global $db, $log, $table;
        $rs=$db->select($sql);
        $log.=add_log(count($rs)." records find", false, true);
        for ($i=0; $i<count($rs); $i++) {
                $subscribers=get_subscribers($rs[$i]);
                $sql="update $table set last_check='".time()."' where id='".$rs[$i]["id"]."'";
                $db->execute($sql);
        }
        if (count($rs)) $log.=add_log("", false);
}

$now=time();
$task=array("ONE TIME", "EVERY DAY", "EVERY WEEK", "EVERY MONTH");
$sql=array();
//      ******************
//      *    TYPE = 0    *
//      ******************
$sql[0]="select
        a.id as id,
        n.id as newsletter_id,
        n.groups,
        n.recipients
from
        $table a,
        $table_n n
where
        a.type=0 and
        a.enabled=1 and
        a.start<=$now and
        a.last_check<a.start and
        n.id=a.newsletter_id
order by a.start";

//      ******************
//      *    TYPE = 1    *
//      ******************
$dt=86400;
$t=mktime(0, 0, 0, date("m"), date("d"), date("Y"));
$sql[1]="select
        a.id as id,
        n.id as newsletter_id,
        n.groups,
        n.recipients
from
        $table a,
        $table_n n
where
        a.type=1 and
        a.enabled=1 and
        a.start<=$now and
        (a.end>=$now or a.end=0) and
        a.last_check<$t and
        mod(floor(($now-start)/$dt), a.period)=0 and
        n.id=a.newsletter_id
order by a.start";

//      ******************
//      *    TYPE = 2    *
//      ******************

$d=date("w");
$sql[2]="select
        a.id as id,
        n.id as newsletter_id,
        n.groups,
        n.recipients
from
        $table a,
        $table_n n
where
        a.type=2 and
        a.enabled=1 and
        a.start<=$now and
        (a.end>=$now or a.end=0) and
        a.last_check<$t and
        mod(floor(floor(($now-start)/$dt)/7), a.period)=0 and
        (s.list like '$d' or a.list like '$d,%' or a.list like '%,$d,%' or a.list like '%,$d') and
        n.id=a.newsletter_id
order by a.start";

//      ******************
//      *    TYPE = 3    *
//      ******************

$d=date("d");
$m=date("m");
$sql[3]="select
        a.id as id,
        n.id as newsletter_id,
        n.groups,
        n.recipients
from
        $table a,
        $table_n n
where
        a.type=3 and
        a.enabled=1 and
        a.start<=$now and
        (a.end>=$now or a.end=0) and
        a.last_check<$t and
        a.period=$d and
        (a.list like '$m' or a.list like '$m,%' or a.list like '%,$m,%' or a.list like '%,$m') and
        n.id=a.newsletter_id
order by a.start";

for ($i=0; $i<count($task); $i++) {
        $log.=add_log("Check \"".$task[$i]."\" tasks: ", true, false);
        check_task($sql[$i]);
}
$db->close();
?>