<?xml version="1.0" encoding="UTF-8"?>
<!-- Only the settings with values not equal to defaults are in this file. If you want to see the
full list of available settings, check the amstock_settings.xml file in the amstock folder. -->
<settings>
	<margins>0</margins>                                                   
	<redraw>true</redraw>
	<number_format>  
		<letters>
			<letter number="1000">K</letter>
			<letter number="1000000">M</letter>
			<letter number="1000000000">B</letter>
		</letters>      
	</number_format>
	<data_sets>
		<data_set did="0">
			<title>{title}</title>
			<short>{short}</short>
			<color>000000</color>
			<file_name>{dataUrl}</file_name>
			<csv>
				<reverse>false</reverse>
				<date_format>YYYY-MM-DD</date_format>
				<columns>
					<column>date</column>
					{row:GRAPH}<column>{name}</column>{/row}
				</columns>
			</csv>
		</data_set>
	</data_sets>

	<charts>
		<chart cid="0">
			<height>60</height>
			<title>{rs:CHART_VALUE}</title>
			<border_color>#CCCCCC</border_color>
			<border_alpha>100</border_alpha>
     
			<values>
				<x>
					<bg_color>#E4E4E4</bg_color>
				</x>        
			</values>
			<legend>
				<show_date>true</show_date>
			</legend>

			<column_width>100</column_width>

			<events>
				<color>FF0000</color>
			</events>

			<graphs>
				{row:GRAPH}
				<graph gid="{id}">
					<title>{title}</title>
					<color>{color}</color>
					<fill_alpha>60</fill_alpha>  			
					<data_sources>
						<close>{name}</close>
					</data_sources>
					<period_value>sum</period_value>
					<width>{width}</width>

					<bullet>round_outline</bullet>
					<smoothed>false</smoothed>

					<legend>
						<date key="true" title="true">{leave:close}</date>
						<period key="true" title="true">{leave:sum}</period>
					</legend>         
				</graph>
				{/row}
			</graphs>
		</chart>
	</charts>

	<data_set_selector>
		<enabled>false</enabled>
	</data_set_selector>
  
	<period_selector>
		<periods>
			<period type="DD" count="1">{rs:STATISTICS_GRAPH_BY_DAY}</period>
			<period selected="true" type="DD" count="7">{rs:STATISTICS_GRAPH_BY_WEEK}</period>
			<period type="MM" count="1">{rs:STATISTICS_GRAPH_BY_MONTH}</period>
			<period type="YYYY" count="1">{rs:STATISTICS_GRAPH_BY_YEAR}</period>
			<period type="MAX">{rs:STATISTICS_GRAPH_BY_ALL}</period>
		</periods>

		<periods_title>{rs:STATISTICS_GRAPH_BY}:</periods_title>
		<custom_period_title>{rs:STATISTICS_PERIOD}:</custom_period_title> 
	</period_selector>

	<header>
		<enabled>false</enabled>
	</header>

	<scroller>
		<graph_data_source>{scrollerData}</graph_data_source>
		<resize_button_style>dragger</resize_button_style>
		<playback>
			<enabled>true</enabled>
			<speed>3</speed>
		</playback>
	</scroller>

	<strings>
		<processing_data>{rs:CHART_PROCESSING_DATA}</processing_data>
		<loading_data>{rs:CHART_LOADING_DATA}</loading_data>
		<wrong_date_format>{rs:CHART_WRONG_DATE_FORMAT}</wrong_date_format>
		<collecting_data>{rs:CHART_COLLECTING_DATA}</collecting_data>
		<no_data>{rs:CHART_NO_DATA}</no_data>

		<months>
			<jan>{rs:CHART_MONTHS_JAN}</jan>
			<feb>{rs:CHART_MONTHS_FEB}</feb>
			<mar>{rs:CHART_MONTHS_MAR}</mar>
			<apr>{rs:CHART_MONTHS_APR}</apr>
			<may>{rs:CHART_MONTHS_MAY}</may>
			<jun>{rs:CHART_MONTHS_JUN}</jun>
			<jul>{rs:CHART_MONTHS_JUL}</jul>
			<aug>{rs:CHART_MONTHS_AUG}</aug>
			<sep>{rs:CHART_MONTHS_SEP}</sep>
			<oct>{rs:CHART_MONTHS_OCT}</oct>
			<nov>{rs:CHART_MONTHS_NOV}</nov>
			<dec>{rs:CHART_MONTHS_DEC}</dec>    
		</months>

		<weekdays>
			<sun>{rs:CHART_WEEKDAYS_SUN}</sun>
			<mon>{rs:CHART_WEEKDAYS_MON}</mon>
			<tue>{rs:CHART_WEEKDAYS_TUE}</tue>
			<wed>{rs:CHART_WEEKDAYS_WED}</wed>
			<thu>{rs:CHART_WEEKDAYS_THU}</thu>
			<fri>{rs:CHART_WEEKDAYS_FRI}</fri>
			<sat>{rs:CHART_WEEKDAYS_SAT}</sat>
		</weekdays>
	</strings>
  
	<error_messages>
		<enabled>true</enabled>    
	    	<color>#e4e4e4</color>                
		<alpha></alpha>              
		<text_color>#000000</text_color>
	</error_messages>
</settings>
