<?php
include_once "../../../../tools/inc.php";
$page = include("../../../common.php");
$table_stat='stat'.$config["table_prefix"];
$n_id=intval($n_id);

$rate_source_list=array(
	'confirmed'		=> '{rs:STATISTICS_RATE_SOURCE_UNSUBSCRIBES}',
);

$rate_view_list=array(
	'column'		=> '{rs:STATISTICS_RATE_VIEW_COLUMN}',
	'pie'			=> '{rs:STATISTICS_RATE_VIEW_PIE}',
);
$rate_source=(isset($rate_source_list[$rate_source]) ? $rate_source : 'confirmed');
$rate_view=(isset($rate_view_list[$rate_view]) ? $rate_view : 'pie');

$page=new Template('templates/statistics/charts/'.$rate_view.'/index.tpl');
$page->dictionary("common/dict.ru");
$page->assign(array(
	'Title'	=> $rate_source_list[$rate_source],
));
$sql=array();
$sql['pending']=	"select count from $table_stat where code='NEWSLETTER[{$n_id}].UNSUBSCRIBES.PENDING.ALL'";
$sql['all']=		"select count from $table_stat where code='NEWSLETTER[{$n_id}].UNSUBSCRIBES.ALL'";

$all=$db->count($sql['all'], true);
$percent=($db->count($sql['pending'], true)/$all)*100;
$percent=round($percent, ($percent<1 ? 2 : 0));

$legend['confirmed']=array(
	'title'	=> '{rs:LEGEND_UNSUBSCRIBES_CONFIRMED}',
	'color'	=> '8080FF',
	'value'	=>  100-$percent,
);
$legend['pending']=array(
	'title'	=> '{rs:LEGEND_UNSUBSCRIBES_PENDING}',
	'color'	=> 'FF8A00',
	'value'	=> $percent,
);
foreach ($legend as $key => $val) $page->addrow('DATA', array(
	'id'	=> $key,
	'color'	=> $val['color'],
	'title'	=> $val['title'],
	'value'	=> $val['value'],
));
$db->close();
header('Content-Type: text/xml');
print $page->evaluate(false);
?>