<?php
include_once "../../../../tools/inc.php";
$page = include("../../../common.php");
$table_stat='stat'.$config["table_prefix"];
$n_id=intval($n_id);

$rate_source_list=array(
	'delivery'		=> '{rs:STATISTICS_RATE_SOURCE_DELIVERY}',
	'click'			=> '{rs:STATISTICS_RATE_SOURCE_CLICK_THROUGH}',
	'bounced'		=> '{rs:STATISTICS_RATE_SOURCE_BOUNCED}',
);

$rate_view_list=array(
	'column'		=> '{rs:STATISTICS_RATE_VIEW_COLUMN}',
	'pie'			=> '{rs:STATISTICS_RATE_VIEW_PIE}',
);
$rate_source=(isset($rate_source_list[$rate_source]) ? $rate_source : 'delivery');
$rate_view=(isset($rate_view_list[$rate_view]) ? $rate_view : 'pie');

$page=new Template('templates/statistics/charts/'.$rate_view.'/index.tpl');
$page->dictionary("common/dict.ru");
$page->assign(array(
	'Title'	=> $rate_source_list[$rate_source],
));

$sql=array();
$sql['undelivered']=	"select sum(count) from $table_stat where code='NEWSLETTER[{$n_id}].UNDELIVERED'";
$sql['delivered_all']=	"select count from $table_stat where code='NEWSLETTER[{$n_id}].SEND.ALL'";
$sql['click']=		"select count from $table_stat where code='NEWSLETTER[{$n_id}].CLICK.ALL.UNIQUE'";
$sql['click_all']=	"select count from $table_stat where code='NEWSLETTER[{$n_id}].SEND.ALL'";
$sql['bounced']=	"select count from $table_stat where code='NEWSLETTER[{$n_id}].BOUNCED.ALL'";
$sql['bounced_all']=	"select count from $table_stat where code='NEWSLETTER[{$n_id}].SEND.ALL'";

if ($rate_source=='delivery') {
	$all=$db->count($sql['delivered_all'], true);
	$percent=($db->count($sql['undelivered'], true)/$all)*100;
	$percent=round($percent, ($percent<1 ? 2 : 0));
	$legend['delivered']=array(
		'title'	=> '{rs:LEGEND_DELIVERED}',
		'color'	=> '8080FF',
		'value'	=>  100-$percent,
	);
	$legend['undelivered']=array(
		'title'	=> '{rs:LEGEND_UNDELIVERED}',
		'color'	=> 'FF8A00',
		'value'	=> $percent,
	);
} else {
	$all=$db->count($sql[$rate_source.'_all'], true);
	$percent=($db->count($sql[$rate_source], true)/$all)*100;
	$percent=round($percent, ($percent<1 ? 2 : 0));
	if ($rate_source=='click') {
		$legend['click']=array(
			'title'	=> '{rs:LEGEND_CLICK_THROUGHS}',
			'color'	=> '8080FF',
			'value'	=>  $percent,
		);
		$legend['unclick']=array(
			'title'	=> '{rs:LEGEND_UNCLICK_THROUGHS}',
			'color'	=> 'FF8A00',
			'value'	=> 100-$percent,
		);
	} elseif ($rate_source=='bounced') {
		$legend['unbounced']=array(
			'title'	=> '{rs:LEGEND_UNBOUNCED}',
			'color'	=> '8080FF',
			'value'	=> 100-$percent,
		);
		$legend['bounced']=array(
			'title'	=> '{rs:LEGEND_BOUNCED}',
			'color'	=> 'FF8A00',
			'value'	=>  $percent,
		);
	}
}

foreach ($legend as $key => $val) $page->addrow('DATA', array(
	'id'	=> $key,
	'color'	=> $val['color'],
	'title'	=> $val['title'],
	'value'	=> $val['value'],
));
$db->close();
header('Content-Type: text/xml');
print $page->evaluate(false);
?>