<?php
include_once "../../../../tools/inc.php";
include("../../../common.php");
$module_name='campaigns';
$sub_module='click_through';
$table_log='stat_opened_newsletters'.$config["table_prefix"];
$table_c='stat_links'.$config["table_prefix"];
$table_s='subscribers'.$config["table_prefix"];
$n_id=intval($n_id);
$sort_d=(isset($sort_d) ? $sort_d : 0);
$sort=(in_array($sort, array('mail', 'name', 'date_created', 'ip', 'browser', 'os')) ? $sort : "date_created");
$n=$settings["rec_count"];
$link->add('n_id');
$link->add('log_type');
$offset_link=new Link($link->get());
$offset_link->add("sort");
$offset_link->add("sort_d");

$page = new Template("templates/statistics/{$module_name}/{$sub_module}_log.tpl");
$page->dictionary("common/dict.ru");

$where="where c.newsletter_id={$n_id}";
$sql="select count(*) from $table_c c ".($log_type ? "left join {$table_s} s on s.id=c.subscriber_id " : '').$where.($log_type ? ' group by s.mail' : '');
$count=$db->count($sql, true);
$i=ceil($count/$n)-1;
$offset=(($offset>$i) ? $i : ($offset<0 ? 0 : $offset));
$sql="select s.id as s_id, s.mail, s.name".($log_type ? ", min(c.date_created) as date_created" : ", c.date_created").", c.url, c.ip, c.browser, c.os from {$table_c} c
left join {$table_s} s on s.id=c.subscriber_id
{$where}".($log_type ? ' group by s.mail' : '')."
order by {$sort} ".($sort_d ? " DESC" : "")."
limit ".($offset*$n). ", $n";
$rs = $db->execute($sql);
while ($row=$db->get_row($rs)) {
	$row['date_created']=date($settings["date_format"]." [H:i]", $row["date_created"]);
	$page->addrow("LOG_LINE", $row);
}


$page->assign(array(
	'PATH'			=> $PATH,
	'n_id'			=> $n_id,
	'offset'		=> get_new_offsets($count, $n, 'logData.php'.$offset_link->get(), $offset),

	'sort_mail_img'		=> ($sort=="mail" ? ($sort_d ? "_asc" : "_desc") : ""),
	'sort_name_img'		=> ($sort=="name" ? ($sort_d ? "_asc" : "_desc") : ""),
	'sort_date_created_img'	=> ($sort=="date_created" ? ($sort_d ? "_asc" : "_desc") : ""),
	'sort_ip_img'		=> ($sort=="ip" ? ($sort_d ? "_asc" : "_desc") : ""),
	'sort_browser_img'	=> ($sort=="browser" ? ($sort_d ? "_asc" : "_desc") : ""),
	'sort_os_img'		=> ($sort=="os" ? ($sort_d ? "_asc" : "_desc") : ""),
	'log_count'		=> $count,
));
$db->close();
print $page->evaluate();
exit;
?>