<?php
include_once "../../../../tools/inc.php";
$page = include("../../../common.php");
$table_stat='stat'.$config["table_prefix"];
$n_id=intval($n_id);

$rate_source_list=array(
	'bounced'		=> '{rs:STATISTICS_RATE_SOURCE_BOUNCED}',
);

$rate_view_list=array(
	'column'		=> '{rs:STATISTICS_RATE_VIEW_COLUMN}',
	'pie'			=> '{rs:STATISTICS_RATE_VIEW_PIE}',
);
$rate_source=(isset($rate_source_list[$rate_source]) ? $rate_source : 'bounced');
$rate_view=(isset($rate_view_list[$rate_view]) ? $rate_view : 'pie');

$page=new Template('templates/statistics/charts/'.$rate_view.'/index.tpl');
$page->dictionary("common/dict.ru");
$page->assign(array(
	'Title'	=> $rate_source_list[$rate_source],
));

$sql=array();
$sql['bounced']=	"select count from $table_stat where code='NEWSLETTER[{$n_id}].BOUNCED.ALL'";
$sql['bounced_all']=	"select count from $table_stat where code='NEWSLETTER[{$n_id}].SEND.ALL'";

$all=$db->count($sql[$rate_source.'_all'], true);
$percent=($db->count($sql[$rate_source], true)/$all)*100;
$percent=round($percent, ($percent<1 ? 2 : 0));
$legend['unbounced']=array(
	'title'	=> '{rs:LEGEND_UNBOUNCED}',
	'color'	=> '8080FF',
	'value'	=> 100-$percent,
);
$legend['bounced']=array(
	'title'	=> '{rs:LEGEND_BOUNCED}',
	'color'	=> 'FF8A00',
	'value'	=>  $percent,
);
foreach ($legend as $key => $val) $page->addrow('DATA', array(
	'id'	=> $key,
	'color'	=> $val['color'],
	'title'	=> $val['title'],
	'value'	=> $val['value'],
));
$db->close();
header('Content-Type: text/xml');
print $page->evaluate(false);
?>