function setPeriodType(id) {
	var e=document.getElementById('period_type_'+id);
	if (e) {
		e.checked=true;
	}
}

function StatInit() {
	$("#sourceMenu .item").click(onSourceClick);
	$("#rateSourceMenu .item").click(onRateSourceClick);
	$("#rateViewMenu .item").click(onRateViewClick);
	$("#trendByMenu .item").click(onTrendByClick);
}

function deselectSourceItem(id) {
	$("#"+id).html($("#"+id).find(".right").html());
}

function selectSourceItem(id) {
	$("#"+id).html(sourceMenuActiveContainer.replace('%item%', $("#"+id).html()));
}

function createSourceChart(newsletter_id, graph_source) {
	var so = new SWFObject(PATH+"charts/amstock.swf", "amline", "100%", "350", "8", "#FFFFFF");
	so.addParam("wmode", "opaque");
	so.addVariable("path", "");
	so.addVariable("settings_file", encodeURIComponent('topChartSettings.php?n_id='+newsletter_id+'&graph_source='+graph_source));
	so.write("flashcontent");
}

function createRateChart(newsletter_id, rate_source, rate_view) {
	var so = new SWFObject(PATH+"charts/"+(rate_view=='pie' ? 'fcp-pie-chart.swf' : 'amcolumn.swf'), "rateChart", "600", "300", "8", "#FFFFFF");
	so.addParam("wmode", "opaque");
	so.addVariable((rate_view=='pie' ? 'xml_file' : 'data_file'), encodeURIComponent('rateChartData.php?n_id='+newsletter_id+'&rate_source='+rate_source+'&rate_view='+rate_view));
	if (rate_view=='column') {
		so.addVariable("settings_file", encodeURIComponent(PATH+'charts/amcolumn_settings.xml'));
		so.addVariable("preloader_color", "#999999");
	}
	so.write("rateChartContainer");
}

function onSourceClick(e) {
	e.cancelBubble = true;
	if (e.stopPropagation) e.stopPropagation();
	id=$(this).attr("id");
	if (currentSourceMenuItem!=id) {
		deselectSourceItem(currentSourceMenuItem);
		selectSourceItem(id);
		currentSourceMenuItem=id;
		createSourceChart(newsletter_id, currentSourceMenuItem.replace('source_', ''));
	}
}

function onRateSourceClick(e) {
	id=$(this).attr("id");
	if (currentRateSourceMenuItem!=id) {
		$("#"+currentRateSourceMenuItem).attr('className', 'item');
		$("#"+id).attr('className', 'item active');
		currentRateSourceMenuItem=id;
		createRateChart(newsletter_id, currentRateSourceMenuItem.replace('rate_source_', ''), currentRateViewMenuItem.replace('rate_view_', ''));
	}
}

function onRateViewClick(e) {
	id=$(this).attr("id");
	if (currentRateViewMenuItem!=id) {
		deselectSourceItem(currentRateViewMenuItem);
		selectSourceItem(id);
		currentRateViewMenuItem=id;
		createRateChart(newsletter_id, currentRateSourceMenuItem.replace('rate_source_', ''), currentRateViewMenuItem.replace('rate_view_', ''));
	}
}

function onTrendByClick(e) {
	id=$(this).attr("id");
	if (currentTrendByMenuItem!=id) {
		deselectSourceItem(currentTrendByMenuItem);
		selectSourceItem(id);
		currentTrendByMenuItem=id;
		Trend.setParameter('n_id', newsletter_id);
		Trend.setParameter('trend_by', currentTrendByMenuItem.replace('trend_by_', ''));
		//Trend.setParameter('date_start', '{date_start}');
		//Trend.setParameter('date_end', '{date_end}');
		//Trend.setParameter('period', '{period}');
		Trend.getData();
	}
}

$(document).ready(StatInit);
