// Version 1.0.0

var Log=new Object();
Log.url=	'';
Log.parameters=	new Object();

Log.setParameter = function(name, value) {
	if (name) this.parameters[name]=value;
}

Log.setUrl = function(url) {
	this.url=url;
}

Log.getData = function() {
	Preloader.show();
	if (this.url) $.get(this.url, this.parameters, Log.onLoadData, 'html');
}

Log.onLoadData = function(data) {
	Preloader.hide();
	$('#logData').html(data);
	$('#logData .header span').click(Log.onSortClick);
	$('#logOffset a').click(Log.onOffsetClick);
	$('#logFilter .header .item').click(Log.onTypeClick);
	onResize();
}

Log.onSortClick = function() {
	id=$(this).attr('id').replace('log_sort_by_', '');
	Log.setParameter('sort_d', (Log.parameters['sort']==id ? 1-Log.parameters['sort_d'] : 0));
	Log.setParameter('sort', id);
	Log.getData();
	return false;
}

Log.onTypeClick = function() {
	id=$(this).attr('id').replace('log_type_', '');
	if (id!=Log.parameters['log_type']) {
		$('#log_type_'+Log.parameters['log_type']).toggleClass('active');
		$('#log_type_'+id).toggleClass('active');
		Log.setParameter('log_type', id);
		Log.getData();
	}
}

Log.changeCount = function() {
	Log.setParameter('_cp', $("select[name='_cp']").attr('value'));
	Log.getData();
	return false;
}

Log.onOffsetClick = function() {
	var url=$(this).attr('href');
	if (url) $.get(url, '', Log.onLoadData, 'html');
	return false;
}
