<?php
if (!is_file('../tools/inc.php')) {
	header('Location: ../install/');
	exit;
}
$first=true;
include_once "../tools/inc.php";
$page = include("common.php");
include("../tools/function.string.php");
include("../tools/function.sql.php");

// Newsletters

$table="newsletters".$config["table_prefix"];
$table_sg='subscribers_group'.$config["table_prefix"];

$where=(isset($user_permissions['newsletters_list']) ? "where n.id in (".$user_permissions['newsletters_list'].")" : '');

$sql="select
	n.id,
	n.name,
	n.groups,
	n.last_sent
from
	$table n
$where
group by n.id
order by last_sent DESC
limit 5";

$rs = $db->execute($sql);
while ($data=$db->get_row($rs)) {
	$sql="select subscribers_id from $table_sg where
		'{$data['groups']}' like concat(group_id) or 
		'{$data['groups']}' like concat(group_id, ',%') or
		'{$data['groups']}' like concat('%,', group_id) or
		'{$data['groups']}' like concat('%,', group_id, ',%')
	group by subscribers_id";

	$data['name']=shortStr($data['name']);
	$data['subscribers']=number_format($db->count($sql), 0, ',', ' ');
	$data["last_sent"]=($data["last_sent"] ? date('M j, Y, h:ia', $data["last_sent"]) : '-');
	$page->addrow("NEWSLETTER_LINE", $data);
}

// Mailing Groups

$table="mailing_groups".$config["table_prefix"];
$table_sg="subscribers_group".$config["table_prefix"];
$table_s="subscribers".$config["table_prefix"];
$table_um="users_mailing_groups".$config["table_prefix"];

$where=(isset($user_permissions['groups_list']) ? "where mg.id in (".$user_permissions['groups_list'].")" : '');

$sql="select mg.*, count(s.id) as count from $table mg
LEFT JOIN $table_sg sg ON sg.group_id=mg.id
LEFT JOIN $table_s s ON sg.subscribers_id=s.id
$where
group by mg.id
order by mg.modify_time DESC
limit 5";

$rs = $db->execute($sql);
while ($data=$db->get_row($rs)) {
	$data['name']=shortStr($data['title']);
	$data['subscribers']=number_format($data['count'], 0, ',', ' ');
	$data["modify_time"]=($data["modify_time"] ? date('M j, Y, h:ia', $data["modify_time"]) : '-');
	$page->addrow("MAILING_GROUPS_LINE", $data);
}

// Recent Subscribers

$table="subscribers".$config["table_prefix"];

if (!isset($access["admin"])) $where="where owner_id='".$ui["id"]."'";

$sql="select * from $table $where order by modify_time DESC limit 5";
$rs = $db->execute($sql);
while ($data=$db->get_row($rs)) {
	$data['name']=shortStr($data['name']);
	$data["modify_time"]=($data["modify_time"] ? date('M j, Y, h:ia', $data["modify_time"]) : '-');
	$page->addrow("SUBSCRIBERS_LINE", $data);
}


// Unsubscribes
$table_u='stat_unsubscribes'.$config["table_prefix"];
$table_s='subscribers'.$config["table_prefix"];

$where="where u.status='1'";
$sql="select s.id as s_id, s.mail, s.name, u.date_created as modify_time from {$table_u} u
left join {$table_s} s on s.id=u.subscriber_id
{$where}
order by modify_time DESC
limit 5";
$rs = $db->execute($sql);
while ($data=$db->get_row($rs)) {
	$data['name']=shortStr($data['name']);
	$data["modify_time"]=($data["modify_time"] ? date('M j, Y, h:ia', $data["modify_time"]) : '-');
	$page->addrow("UNSUBSCRIBES_LINE", $data);
}


$page->section('OVERVIEW');
print $page->evaluate();
$db->close();
exit;
?>