<?php
include_once "../../tools/inc.php";
$page = include("../common.php");
include("../tools/function.string.php");
include("../tools/function.sql.php");
$n=$settings["rec_count"];
$table="campaign_schedule".$config["table_prefix"];
$table_n="newsletters".$config["table_prefix"];
$table_un="users_newsletter".$config["table_prefix"];
$access=check_level("Campaign Schedule");
$sort=(in_array($sort, array("date_created", "day", "name")) ? $sort : "date_created");
$sort_d=(isset($sort_d) ? 1 : 0);

$sort_link=new Link($link->get());
$link->add("sort");
$link->add("sort_d");
$filter_link=new Link($link->get());
$link->add("_search");
$sort_link->add("_search");
$offset_link=new Link($link->get());
$link->add("offset");

$message_list=array(
        1 => "{rs:MSG_CAMPAIGN_SCHEDULE} {rs:MSG_CREATED}",
        2 => "{rs:MSG_CAMPAIGN_SCHEDULE} {rs:MSG_UPDATED}",
        3 => "{rs:MSG_CAMPAIGN_SCHEDULE} {rs:MSG_DELETED}",
);

function check_all() {
        global $newsletter_id, $PATH, $db, $table_n;
        if (!is_val($table_n, "where id='$newsletter_id'")) {
                $db->close();
                header("Location: ".$PATH."newsletters/");
                exit;
        }
}
$message=new Message();
$error=new Message("error");
if (isset($_r)) $message->add($message_list[$_r]);
if (isset($del) and (isset($access["delete"]) or isset($access["admin"]))) {
        $del=(is_array($del) ? implode($del, ", ") : $del);
        $sql="delete from $table where id in ($del)";
        if (!isset($access["admin"])) $sql.=" and owner_id='".$ui["id"]."'";
        $db->execute($sql);
        $link->add("_r", 3);
        $db->close();
        header("Location: ".$link->get());
        exit;
} elseif (isset($edit) and (isset($access["edit"]) or isset($access["view"]) or isset($access["admin"]))) {
        $sql="select * from $table where id='$edit'";
        if (!isset($access["admin"])) $sql.=" and owner_id='".$ui["id"]."'";
        $rs=$db->select($sql);
        $data=$rs[0];
        $newsletter_list=$db->get_array($table_n, "id", "name", ($news_list ? "where id in ($news_list)" : "")." order by title");
        reset($newsletter_list);
        $r["newsletter_id"]=(isset($newsletter_list[$r["newsletter_id"]]) ? $r["newsletter_id"] : (isset($newsletter_list[$data["newsletter_id"]]) ? $data["newsletter_id"] : key($newsletter_list)));
        if (!isset($data["id"])) {
                $edit=0;
                $r["date_created"]=time();
                $r["owner_id"]=$ui["id"];
                $sql="select max(day) from $table";
                if (!isset($access["admin"])) $sql.=" where owner_id='".$r["owner_id"]."'";
                $data=array(
                        "newsletter_id" => $r["newsletter_id"],
                        "enabled"       => 1,
                        "day"           => $db->count($sql, true),
                        "position"      => 0,
                );
                if ($data["day"]>0) $data["day"]++;
        } else {
                $edit=$data["id"];
                $r["date_created"]=$data["date_created"];
                $r["owner_id"]=$data["owner_id"];
        }
        if (isset($save)) {
                $r=check_array($r);
                $r["day"]=($r["day"]<0 ? 0 : $r["day"]);
                $r["position"]=($r["position"]<0 ? 0 : $r["position"]);
                if (!$r["newsletter_id"]) $error->add("{rs:ERROR_NEWSLETTER_ID}");
		if (!$error->count and !isset($access['edit']) and !isset($access['admin'])) $error->add('{rs:ERROR_ACCESS_RESTRICTED}');
                if (!$error->count) {
                        $r["modify_user"]=$ui["id"];
                        $r["modify_time"]=time();
                        $fields="date_created, newsletter_id, day, position, enabled, owner_id, modify_user, modify_time";
                        $sql=($edit ? get_sql_update($table, $fields, $r,"where id='$edit'") : get_sql_insert($table, $fields, $r));
                        $db->execute($sql);
                        $db->close();
                        $link->add("_r", ($edit ? 2 : 1));
                        header("Location: ".$link->get());
                        exit;
                } else {
                        $data=html_string($r, true);
                }
        } else $data=html_string($data, false);
        $page->section("CAMPAIGN_SCHEDULE_EDIT");
        get_row_from_array("NEWSLETTER_SELECT", $newsletter_list, $data["newsletter_id"]);
        $data["BACK_LINK"]=($link->get() ? $link->get() : './');
        $data["BACK_TITLE"]="{rs:TITLE_CAMPAIGN_SCHEDULE}";
	$data["WINDOW_TITLE"]="{rs:EDIT_CAMPAIGN_SCHEDULE}";
        $page->assign($data);
} elseif (isset($access["view"]) or isset($access["admin"])) {
        if (isset($edit) or isset($del) or isset($permission)) $error->add("{rs:ERROR_ACCESS_RESTRICTED}");
        $page->section("CAMPAIGN_SCHEDULE");
        $where="where cs.newsletter_id=n.id";
        if (!isset($access["admin"])) $where.=" and cs.owner_id='".$ui["id"]."'";
        $where=get_search_where("n.name", $_search, $where);
        $sql="select count(*)
        from
                $table cs,
                $table_n n
        $where";
        $rs=$db->select($sql);
        $count=$rs[0][0];
        $i=ceil($count/$n)-1;
        $offset=(($offset>$i) ? $i : ($offset<0 ? 0 : $offset));
        $sql="select cs.*, n.name as newsletter_title
        from
                $table cs,
                $table_n n
        $where
        order by ".($sort=="day" ? "day".($sort_d ? " DESC" : "").", position" : $sort).($sort_d ? " DESC" : "")." limit ".($offset*$n). ", $n";
        $rs = $db->select($sql);
        for ($i=0; $i<count($rs); $i++) {
                $data=$rs[$i];
                $data["date_created"]=date($settings["date_format"]." [H:i]", $data["date_created"]);
                $data["disabled"]=!$data["enabled"];
                $page->addrow("LINE", $data);
        }
	$sort_link=$sort_link->get();
        $page->assign(array(
                "count"                 => $count,
                "offset"                => get_new_offsets($count, $n, $offset_link->get(), $offset),
                "search"                => html_string($_search),
                "BACK_LINK"             => $PATH,
                "BACK_TITLE"            => "{rs:TITLE_MAIN_MENU}",
                "sort_by_date"          => $sort_link.($sort_link ? '&' : '?')."sort=date_created".($sort=="date_created" ? ($sort_d ? "" : "&sort_d=1") : ""),
                "sort_by_day"           => $sort_link.($sort_link ? '&' : '?')."sort=day".($sort=="day" ? ($sort_d ? "" : "&sort_d=1") : ""),
                "sort_by_name"		=> $sort_link.($sort_link ? '&' : '?')."sort=name".($sort=="name" ? ($sort_d ? "" : "&sort_d=1") : ""),
                "sort_date_img"         => ($sort=="date_created" ? ($sort_d ? "_asc" : "_desc") : ""),
                "sort_day_img"          => ($sort=="day" ? ($sort_d ? "_asc" : "_desc") : ""),
                "sort_name_img"		=> ($sort=="name" ? ($sort_d ? "_asc" : "_desc") : ""),
		"WINDOW_TITLE"		=> "{rs:TITLE_CAMPAIGN_SCHEDULE}",
        ));
	$page->section("SHOW_SEARCH");
} else {
        $page->section("ACCESS_DENIED");
        $error->add("{rs:ERROR_ACCESS_RESTRICTED}");
}
add_to_tree("{rs:TITLE_CAMPAIGN_SCHEDULE}", "campaign_schedule/");
$db->close();
$page->assign(array(
        "TITLE"                 => "{rs:TITLE_CAMPAIGN_SCHEDULE}",
        "ERROR"                 => ($error->count ? $error->get() : ""),
        "MESSAGE"               => ($message->count ? $message->get() : ""),
        "LINK"                  => $link->get(),
        "FILTER_LINK"           => $filter_link->get(),
        "is_campaign_schedule"  => 1,
        "IMG"                   => "campaign_schedule.gif",
));
print $page->evaluate();
?>