<?php
include_once "../../tools/inc.php";
$page = include("../common.php");
include("../tools/function.string.php");
include("../tools/function.sql.php");
$n=$settings["rec_count"];
$table="autoresponder".$config["table_prefix"];
$table_n="newsletters".$config["table_prefix"];
$table_un="users_newsletter".$config["table_prefix"];
$access=check_level("Autoresponder");
$sort=(in_array($sort, array("date_created", "newsletter_title", "start", "end")) ? $sort : "date_created");
$sort_d=(isset($sort_d) ? 1 : 0);

$sort_link=new Link($link->get());
$link->add("sort");
$link->add("sort_d");
$filter_link=new Link($link->get());
$link->add("_search");
$sort_link->add("_search");
$offset_link=new Link($link->get());
$link->add("offset");

$message_list=array(
        1 => "{rs:MSG_AUTORESPONDER} {rs:MSG_CREATED}",
        2 => "{rs:MSG_AUTORESPONDER} {rs:MSG_UPDATED}",
        3 => "{rs:MSG_AUTORESPONDERS} {rs:MSG_DELETED}",
);

function check_all() {
        global $newsletter_id, $PATH, $db, $table_n;
        if (!is_val($table_n, "where id='$newsletter_id'")) {
                $db->close();
                header("Location: ".$PATH."newsletters/");
                exit;
        }
}

$type_list=array(
        0 => "{rs:AUTORESPONDER_TYPE_0}",
        1 => "{rs:AUTORESPONDER_TYPE_1}",
        2 => "{rs:AUTORESPONDER_TYPE_2}",
        3 => "{rs:AUTORESPONDER_TYPE_3}",
);

$day_list=array(
        0 => "{rs:DAY_0}",
        1 => "{rs:DAY_1}",
        2 => "{rs:DAY_2}",
        3 => "{rs:DAY_3}",
        4 => "{rs:DAY_4}",
        5 => "{rs:DAY_5}",
        6 => "{rs:DAY_6}",
);

$month_list=array(
         1 => "{rs:MONTH_1}",
         2 => "{rs:MONTH_2}",
         3 => "{rs:MONTH_3}",
         4 => "{rs:MONTH_4}",
         5 => "{rs:MONTH_5}",
         6 => "{rs:MONTH_6}",
         7 => "{rs:MONTH_7}",
         8 => "{rs:MONTH_8}",
         9 => "{rs:MONTH_9}",
        10 => "{rs:MONTH_10}",
        11 => "{rs:MONTH_11}",
        12 => "{rs:MONTH_12}",
);


$message=new Message();
$error=new Message("error");
if (isset($_r)) $message->add($message_list[$_r]);
if (isset($del) and (isset($access["delete"]) or isset($access["admin"]))) {
        $del=(is_array($del) ? implode($del, ", ") : $del);
        $sql="delete from $table where id in ($del)";
        if (!isset($access["admin"])) $sql.=" and owner_id='".$ui["id"]."'";
        $db->execute($sql);
        $link->add("_r", 3);
        $db->close();
        header("Location: ".$link->get());
        exit;
} elseif (isset($edit) and (isset($access["edit"]) or isset($access['view']) or isset($access["admin"]))) {
        $sql="select * from $table where id='$edit'";
        if (!isset($access["admin"])) $sql.=" and owner_id='".$ui["id"]."'";
        $rs=$db->select($sql);
        $data=$rs[0];
        if (!isset($data["id"])) {
                $edit=0;
                $r["date_created"]=time();
                $r["owner_id"]=$ui["id"];
                $data=array(
                        "newsletter_id" => $newsletter_id,
                        "enabled"       => 1,
                        "type"          => 0,
                        "start_time"    => date("H:i"),
                        "start_date"    => date($settings["date_format"]),
                        "period"        => 1,
                        "list"          => array(),
                );
                
        } else {
                $edit=$data["id"];
                $r["date_created"]=$data["date_created"];
                $r["owner_id"]=$data["owner_id"];
                $data["start_time"]=date("H:i", $data["start"]);
                $data["start_date"]=date($settings["date_format"], $data["start"]);
                if ($data["end"]) {
                        $data["end_time"]=date("H:i", $data["end"]);
                        $data["end_date"]=date($settings["date_format"], $data["end"]);
                }
                $data["list"]=explode(",", $data["list"]);
        }
        if (isset($save) and $save) {
                $r=check_array($r);
                $start=check_date($r["start_date"]." ".$r["start_time"], $settings["date_format"]." H:i");
                $end=check_date($r["end_date"]." ".$r["end_time"], $settings["date_format"]." H:i");
                $r["period"]=($r["period"]<1 ? 1 : ($r[type]==2 ? ($r["period"]>52 ? 52 : $r["period"]) : ($r["type"]==3 ? ($r["period"]>31 ? 31 : $r["period"]) : $r["period"])));
                if (!$start) $error->add("{rs:ERROR_DATE_TIME}");
                if (($r["end_date"] or $r["end_time"]) and !$end) $error->add("{rs:ERROR_DATE_TIME}");
                if (!$r["newsletter_id"]) $error->add("{rs:ERROR_NEWSLETTER_ID}");
		if (!$error->count and !isset($access['edit']) and !isset($access['admin'])) $error->add('{rs:ERROR_ACCESS_RESTRICTED}');
                if (!$error->count) {
                        $r["start"]=$start;
                        $r["end"]=$end;
                        $r["list"]=implode(",", $r["list"]);
                        $r["modify_user"]=$ui["id"];
                        $r["modify_time"]=time();
                        $fields="date_created, newsletter_id, type, start, end, period, list, enabled, owner_id, modify_user, modify_time";
                        $sql=($edit ? get_sql_update($table, $fields, $r,"where id='$edit'") : get_sql_insert($table, $fields, $r));
                        $db->execute($sql);
                        $db->close();
                        $link->add('_r', ($edit ? 2 : 1));
                        header("Location: ".$link->get());
                        exit;
                } else {
                        $data=html_string($r, true, "html_content");
                }
        } elseif (isset($save)) {
                $r=check_array($r);
                $r["period"]=1;
                $r["list"]=array();
                $data=html_string($r, true);
        } else $data=html_string($data);
        $page->section("AUTORESPONDER_EDIT");
        $sql="select id, name as title from $table_n".($news_list ? " where id in ($news_list)" : "")." order by title";
        get_row_from_sql("NEWSLETTER_SELECT", $sql, $data["newsletter_id"]);
        get_row_from_array("TYPE_SELECT", $type_list, $data["type"]);
        $data["period_type"]=($data["type"]==1 ? "{rs:DAYS}" : ($data["type"]==2 ? "{rs:WEEKS}" : ($data["type"]==3 ? "{rs:MONTHS}" : "")));
        if (in_array($data["type"], array(2, 3))) {
                $data["list_title"]=($data["type"]==2 ? "{rs:DAYS_LIST}" : "{rs:MONTHS_LIST}");
                get_row_from_array("LIST", ($data["type"]==2 ? $day_list : $month_list), $data["list"]);
        }
        $data["show_end"]=($data["type"]>0);
        $data["BACK_LINK"]=($link->get() ? $link->get() : './');
        $data["BACK_TITLE"]="{rs:TITLE_AUTORESPONDER}";
	$data["WINDOW_TITLE"]="{rs:EDIT_AUTORESPONDER}";
        $page->assign($data);
} elseif (isset($access["view"]) or isset($access["admin"])) {
        if (isset($edit) or isset($del) or isset($permission)) $error->add("{rs:ERROR_ACCESS_RESTRICTED}");
        $page->section("AUTORESPONDER");
        $where="where a.newsletter_id=n.id";
        if (!isset($access["admin"])) $where.=" and a.owner_id='".$ui["id"]."'";
        $where=get_search_where("n.name", $_search, $where);
        $sql="select count(*) from $table a, $table_n n $where";
        $rs=$db->select($sql);
        $count=$rs[0][0];
        $i=ceil($count/$n)-1;
        $offset=(($offset>$i) ? $i : ($offset<0 ? 0 : $offset));
        $sql="select a.*, n.name as newsletter_title
        from
                $table a,
                $table_n n
        $where
        order by $sort".($sort_d ? " DESC" : "")." limit ".($offset*$n). ", $n";
        $rs = $db->select($sql);
        for ($i=0; $i<count($rs); $i++) {
                $data=$rs[$i];
                $data["date_created"]=date($settings["date_format"]." [H:i]", $data["date_created"]);
                $data["start"]=date($settings["date_format"]." [H:i]", $data["start"]);
                $data["end"]=($data["end"] ? date($settings["date_format"]." [H:i]", $data["end"]) : "");
                $data["disabled"]=!$data["enabled"];
                $page->addrow("LINE", $data);
        }
	$sort_link=$sort_link->get();
        $page->assign(array(
                "count"         => $count,
                "offset"        => get_new_offsets($count, $n, $offset_link->get(), $offset),
                "search"        => html_string($_search),
                "BACK_LINK"     => $PATH,
                "BACK_TITLE"    => "{rs:TITLE_MAIN_MENU}",
                "sort_by_date"  => $sort_link.($sort_link ? '&' : '?')."sort=date_created".($sort=="date_created" ? ($sort_d ? "" : "&sort_d=1") : ""),
                "sort_by_title" => $sort_link.($sort_link ? '&' : '?')."sort=newsletter_title".($sort=="newsletter_title" ? ($sort_d ? "" : "&sort_d=1") : ""),
                "sort_by_start" => $sort_link.($sort_link ? '&' : '?')."sort=start".($sort=="start" ? ($sort_d ? "" : "&sort_d=1") : ""),
                "sort_by_end"   => $sort_link.($sort_link ? '&' : '?')."sort=end".($sort=="end" ? ($sort_d ? "" : "&sort_d=1") : ""),
                "sort_date_img" => ($sort=="date_created" ? ($sort_d ? "_asc" : "_desc") : ""),
                "sort_title_img"=> ($sort=="newsletter_title" ? ($sort_d ? "_asc" : "_desc") : ""),
                "sort_start_img"=> ($sort=="start" ? ($sort_d ? "_asc" : "_desc") : ""),
                "sort_end_img"  => ($sort=="end" ? ($sort_d ? "_asc" : "_desc") : ""),
		"WINDOW_TITLE"	=> "{rs:TITLE_AUTORESPONDER}",
        ));
	$page->section("SHOW_SEARCH");
} else {
        $page->section("ACCESS_DENIED");
        $error->add("{rs:ERROR_ACCESS_RESTRICTED}");
}
add_to_tree("{rs:TITLE_AUTORESPONDER}", "autoresponder/");
$db->close();
$page->assign(array(
        "TITLE"                 => "{rs:TITLE_AUTORESPONDER}",
        "ERROR"                 => ($error->count ? $error->get() : ""),
        "MESSAGE"               => ($message->count ? $message->get() : ""),
        "LINK"                  => $link->get(),
        "FILTER_LINK"           => $filter_link->get(),
        "is_autoresponder"      => 1,
        "IMG"                   => "autoresponder.gif",
));
print $page->evaluate();
?>